jQuery(document).ready(function($) {
	 	
	 	// Check if dropdown is offscreen
	 	$(".zen-menu-horizontal li.parent").on('mouseenter mouseleave', function () {
	 		var item = $(this).index();
	 		$('.zen-menu-horizontal li').removeClass('zen-menu-offscreen');
	 	    
	 	    if(!$('html').hasClass('touch')) {
	 	   	 	$('body').offscreen_check(item);
	 	   	}
	 	});
	 	
	 	$(window).bind("debouncedresize", function() {
	 		$(".zen-menu-horizontal li").on('mouseenter mouseleave', function () {
	 			var item = $(this).index();
	 			$('.zen-menu-horizontal li').removeClass('zen-menu-offscreen');
	 			
	 			if(!$('html').hasClass('touch')) {
	 				 	$('body').offscreen_check(item);
	 				}
	 				        
	 		});
	 	});
	 	
	 	
	 	$('a,h3,span,img').click(function() {
	 		setTimeout(function() {
	 			$('#midCol,.sidebar').matchHeight();
	 		}, 700);	
	 	});
	 	
	 	
	 	// Touch devices
	 	if (Modernizr.touch) {   
	 		jQuery('li.parent > a').click(function(e){
	 		
	 			//If a menu item is a parent and a link then prevent default if sub is hidden
	 			if (!jQuery(this).closest('li.parent').hasClass('open')){
	 				e.preventDefault();
	 				jQuery(this).closest('li.parent').addClass('open');
	 			}
	 		});
	 		
	 		jQuery('body').click(function(e){
	 			//If there is a click elsewhere then remove the open class from parents
	 			if ( !jQuery(e.target).is('li.parent > a') ) {
	 				jQuery('.zen-menu li.parent').removeClass('open');
	 			}
	 		});
	 	}
	 	
	 	if($('.item-page').hasClass('with-image')) {
	 		$('#mainWrap').addClass('with-image');
	 	}
	 	
	 	
	});



(function ($) {
	
	// Checks to see if menu is offscreen and attaches zen-menu-offscreen class
	$.fn.offscreen_check = function (item) {
		var item = item + 1;
		var elm = $('ul:first', this);
		var off = elm .offset();
		var l = off.left;
		var w = elm.width() + 50;
		var docH = $(window).height();
		var docW = $(window).width();
		var isEntirelyVisible = (l+ w <= docW);
			         
		if ( ! isEntirelyVisible ) {
		    $('.zen-menu-horizontal li:nth-child(' + item + ')').addClass('zen-menu-offscreen');
		    
		} else {
		    $(this).parent().removeClass('zen-menu-offscreen');
		}
	};
	
	// Checks to see if menu is offscreen and attaches zen-menu-offscreen class
	$.fn.append_nav = function (collapse) {
		
		var offcanvastarget = '#off-canvas-menu';	
		var window_width = $(window).width();		
		
		if(window_width < collapse) {
			if(!$(offcanvastarget + ' ul').hasClass('simple-list')) {
				var nav = $('#menu ul').html();
				$(offcanvastarget + ' ul').append(nav).addClass('simple-list').parent().addClass('accordion');
			}
		}	
	}
})(jQuery);