(function ($) {
    $.fn.zenaccordion = function (options) {
    
    		// Accordion options
            var settings = $.extend({
                    openfirst: false,
                    showactive: false,
                    selector: '.sidebar',
                    type: 'panel',
                    target: '.sidebar',
                    openicon: 'chevron-right',
                    closeicon: 'chevron-up',
                    submenu: 'hide'
            }, options);
            

            // Hide all sub menu items on load
            // Set some variables
            var allPanels = $('.accordion ul ul').hide();
            var toggler = settings.selector + ' .accordion ul li.parent > a,';
            	toggler += settings.selector + ' .accordion ul li.parent > .zen-menu-heading';
            var open_icon = 'fa-' + settings.openicon + ' zen-icon zen-icon-' + settings.openicon;
            var close_icon = 'fa-' + settings.closeicon + ' zen-icon zen-icon-' + settings.closeicon;
			var expand = '.expand';
			var accordion_first = settings.selector + ' .accordion li.parent:first-child';
            var accordion_active = settings.selector + ' .accordion li.parent.active';
            
            // Append the toggle symbol. We can use this to hide and close items too.
            // Position outside of the link so we can detangle them later
			
	
			
			
            if(!$(toggler).hasClass('expand')) {
            	$(toggler).parent().prepend('<span class="expand zen-icon zen-icon-' + settings.openicon + ' fa fa-' + settings.openicon + '"></span>');
            	
            	toggler += ',';
            	toggler += settings.selector + ' .expand';
            }
            
            if (settings.openfirst) {
                    $(accordion_first + ' ul').slideDown();
                    $(accordion_first + ' .expand').removeClass(open_icon).addClass(close_icon); 
                    $(accordion_first + ' span.zen-menu-heading,' + accordion_active + ' a').addClass('open'); 
            }
            
            
            if (settings.showactive) {
                    $(accordion_active + ' ul').slideDown();
                 	$(accordion_active + ' .expand').removeClass(open_icon).addClass(close_icon); 
                    $(accordion_active + ' span.zen-menu-heading,' + accordion_active + ' a').addClass('open');  
            }
           
            
               
            // What happens when the toggler is clicked
            $(toggler).on('click', function(e) {
            	
            	// Prevent click action
            	if($(this).hasClass('open')) {
            		// Follow the link
            	} else {
            		e.preventDefault();
            	}
            	
            	
            	if($(this).hasClass('expand')) {
            		var target = $(this).parent().children('a,.zen-menu-heading');
            	} else {
            		var target = $(this);
            	}
        		
        		// Slide Open all panels
        		if(settings.type === "accordion") {
        			allPanels.slideUp();
        			$(toggler).find(expand).removeClass(close_icon).addClass(open_icon);	
        		}
        		
        		
        		// If the link that was clicked is already open
          		if($(target).hasClass('open')) {
          		
          			// This item is already open so lets close it
          			$(target).removeClass('open').parent().find('ul').slideUp().find('.open').removeClass('open');
          			
          			// Remove the open icon
          			$(target).parent().find(expand).removeClass(close_icon).addClass(open_icon);
          		
          			// Remove open from all items
      				if(settings.type === "accordion") {
      					$(toggler).removeClass('open');
      					$(toggler).parent().find(expand).removeClass(close_icon).addClass(open_icon);
      				}
          		
          		} else {
          			
          			// Close all panels
          			// Remove open class if using accordion
          			if(settings.type === "accordion") {
          			
          				allPanels.slideUp();
          				$(toggler).removeClass('open');
          				$(toggler).parent().find(expand).removeClass(close_icon).addClass(open_icon);
          			}
          			
          			// Open current item
          			// Toggle expand class
          			if(settings.type === "accordion") {
          				$(target).addClass('open').parent().find('ul').slideDown();
          			} else {
          				$(target).addClass('open').parent().find('ul:first').slideDown();
          			}
          			
          			$(target).parent().find(expand + ':first').addClass(close_icon).removeClass(open_icon).addClass('zen-icon fa');
          			
          		}

            });
      };
})(jQuery);